/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.wishingforsunshine.tiles;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.ServerWorldInfo;
import noobanidus.mods.wishingforsunshine.config.ConfigManager;
import noobanidus.mods.wishingforsunshine.config.ItemType;

public class WishingWellTile
extends TileEntity {
    public WishingWellTile(TileEntityType<? extends WishingWellTile> type) {
        super(type);
    }

    public ItemType itemCollide(ItemEntity itemEntity) {
        ItemType result = this.handleItem(itemEntity.func_92059_d());
        if (result != null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            itemEntity.func_92059_d().func_190918_g(1);
            if (itemEntity.func_92059_d().func_190926_b()) {
                itemEntity.func_70106_y();
            }
        }
        return result;
    }

    public ItemType itemActivated(PlayerEntity player, Hand hand, ItemStack stack) {
        ItemType result = this.handleItem(stack);
        if (result != null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            stack.func_190918_g(1);
            player.func_184611_a(hand, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
        }
        return result;
    }

    private ItemType handleItem(ItemStack stack) {
        if (stack.func_190926_b() || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        ItemType type = ConfigManager.getTypeForItem(stack);
        if (type == null) {
            return null;
        }
        IWorldInfo info1 = this.field_145850_b.func_72912_H();
        if (!(info1 instanceof ServerWorldInfo) || !(this.field_145850_b instanceof ServerWorld)) {
            return null;
        }
        ServerWorldInfo info = (ServerWorldInfo)info1;
        long dayTime = info.func_76073_f();
        switch (type) {
            case RAIN: {
                if (this.field_145850_b.func_72896_J()) {
                    return null;
                }
                if (this.field_145850_b.field_72995_K) {
                    return null;
                }
                info.func_76084_b(true);
                info.func_76080_g(this.field_145850_b.field_73012_v.nextInt(168000) + 12000);
                return type;
            }
            case THUNDER: {
                if (this.field_145850_b.func_72911_I()) {
                    return null;
                }
                if (this.field_145850_b.field_72995_K) {
                    return type;
                }
                info.func_76084_b(true);
                info.func_76069_a(true);
                info.func_76080_g(this.field_145850_b.field_73012_v.nextInt(168000) + 12000);
                info.func_76090_f(this.field_145850_b.field_73012_v.nextInt(168000) + 12000);
                return type;
            }
            case SUNSHINE: {
                if (!this.field_145850_b.func_72911_I() && !this.field_145850_b.func_72896_J()) {
                    return null;
                }
                if (this.field_145850_b.field_72995_K) {
                    return type;
                }
                info.func_76069_a(false);
                info.func_76084_b(false);
                info.func_76080_g(this.field_145850_b.field_73012_v.nextInt(168000) + 12000);
                info.func_76090_f(this.field_145850_b.field_73012_v.nextInt(168000) + 12000);
                return type;
            }
            case SUNRISE: {
                if (!this.field_145850_b.field_72995_K) {
                    long newTime = dayTime + 24000L;
                    ((ServerWorld)this.field_145850_b).func_241114_a_(newTime - newTime % 24000L);
                }
                return type;
            }
            case SUNSET: {
                if (!this.field_145850_b.field_72995_K) {
                    long newTime = dayTime + 24000L;
                    newTime -= newTime % 24000L;
                    ((ServerWorld)this.field_145850_b).func_241114_a_(newTime + 12400L);
                }
                return type;
            }
            case MIDDAY: {
                if (!this.field_145850_b.field_72995_K) {
                    long newTime = dayTime + 24000L;
                    newTime -= newTime % 24000L;
                    ((ServerWorld)this.field_145850_b).func_241114_a_(newTime + 5800L);
                }
                return type;
            }
            case MIDNIGHT: {
                if (!this.field_145850_b.field_72995_K) {
                    long newTime = dayTime + 24000L;
                    newTime -= newTime % 24000L;
                    ((ServerWorld)this.field_145850_b).func_241114_a_(newTime + 17800L);
                }
                return type;
            }
        }
        return null;
    }
}

